package ru.yandex.direct.intapi.entity.showconditions.model.response;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResponseItem {

    @JsonProperty("phrases_added_qty")
    private Integer phrasesAddedQuantity;

    @JsonProperty("is_group_oversized")
    private Integer isGroupOversized;

    @JsonProperty("phrases_exceeds_limit_qty")
    private Integer phrasesExceedsLimitQuantity;

    @JsonProperty("groups_limit_exceeded")
    private Integer groupsLimitExceeded;

    @JsonProperty("phrases")
    private Map<Long, KeywordItemResponse> keywords = new HashMap<>();

    @JsonProperty("retargetings")
    private RetargetingItemsResponse retargetings = new RetargetingItemsResponse();

    @JsonProperty("searchRetargetings")
    private RetargetingItemsResponse searchRetargetings = new RetargetingItemsResponse();

    @JsonProperty("targetInterests")
    private RetargetingItemsResponse targetInterests = new RetargetingItemsResponse();

    @JsonProperty("banners")
    private Map<Long, BannerItemResponse> banners = new HashMap<>();

    @JsonProperty("errors")
    private Set<String> errors;

    @JsonProperty("errors_by_phrases")
    private List<KeywordAddItemError> errorsByPhrases;

    @JsonProperty("copied_from_pid")
    private Long copiedFromAdGroupId;

    public Integer getPhrasesAddedQuantity() {
        return phrasesAddedQuantity;
    }

    public ResponseItem withPhrasesAddedQuantity(Integer phrasesAddedQuantity) {
        this.phrasesAddedQuantity = phrasesAddedQuantity;
        return this;
    }

    public Integer getIsGroupOversized() {
        return isGroupOversized;
    }

    public ResponseItem withIsGroupOversized(Integer isGroupOversized) {
        this.isGroupOversized = isGroupOversized;
        return this;
    }

    public Integer getPhrasesExceedsLimitQuantity() {
        return phrasesExceedsLimitQuantity;
    }

    public ResponseItem withPhrasesExceedsLimitQuantity(Integer phrasesExceedsLimitQuantity) {
        this.phrasesExceedsLimitQuantity = phrasesExceedsLimitQuantity;
        return this;
    }

    public ResponseItem withGroupsLimitExceeded(Integer groupsLimitExceeded) {
        this.groupsLimitExceeded = groupsLimitExceeded;
        return this;
    }

    public Map<Long, KeywordItemResponse> getKeywords() {
        return keywords;
    }

    public ResponseItem withKeywords(
            Map<Long, KeywordItemResponse> keywords) {
        this.keywords = keywords;
        return this;
    }

    public RetargetingItemsResponse getRetargetings() {
        return retargetings;
    }

    public ResponseItem withRetargetings(
            RetargetingItemsResponse retargetings) {
        this.retargetings = retargetings;
        return this;
    }

    public RetargetingItemsResponse getSearchRetargetings() {
        return searchRetargetings;
    }

    public ResponseItem withSearchRetargetings(
            RetargetingItemsResponse searchRetargetings) {
        this.searchRetargetings = searchRetargetings;
        return this;
    }

    public RetargetingItemsResponse getTargetInterests() {
        return targetInterests;
    }

    public Set<String> getErrors() {
        return errors;
    }

    public ResponseItem withErrors(Set<String> errors) {
        this.errors = errors;
        return this;
    }

    public List<KeywordAddItemError> getErrorsByPhrases() {
        return errorsByPhrases;
    }

    public ResponseItem withErrorsByPhrases(
            List<KeywordAddItemError> errorsByPhrases) {
        this.errorsByPhrases = errorsByPhrases;
        return this;
    }

    public Long getCopiedFromAdGroupId() {
        return copiedFromAdGroupId;
    }

    public ResponseItem withCopiedFromAdGroupId(final Long copiedFromAdGroupId) {
        this.copiedFromAdGroupId = copiedFromAdGroupId;
        return this;
    }

    public Map<Long, BannerItemResponse> getBanners() {
        return banners;
    }

    public ResponseItem withBanners(Map<Long, BannerItemResponse> banners) {
        this.banners = banners;
        return this;
    }
}
