package ru.yandex.direct.intapi.entity.showconditions.model.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class TrafficVolumeItem {

    @JsonProperty("bid_price")
    private Long bidPrice;

    @JsonProperty("amnesty_price")
    private Long amnestyPrice;

    @JsonProperty("dont_show_bid_price")
    private Integer dontShowBidPrice;

    @JsonProperty("show_in_table")
    private Integer showInTable;

    public Long getBidPrice() {
        return bidPrice;
    }

    public TrafficVolumeItem withBidPrice(Long bidPrice) {
        this.bidPrice = bidPrice;
        return this;
    }

    public Long getAmnestyPrice() {
        return amnestyPrice;
    }

    public TrafficVolumeItem withAmnestyPrice(Long amnestyPrice) {
        this.amnestyPrice = amnestyPrice;
        return this;
    }

    public Integer getDontShowBidPrice() {
        return dontShowBidPrice;
    }

    public TrafficVolumeItem withDontShowBidPrice(final Integer dontShowBidPrice) {
        this.dontShowBidPrice = dontShowBidPrice;
        return this;
    }

    public Integer getShowInTable() {
        return showInTable;
    }

    public TrafficVolumeItem withShowInTable(final Integer showInTable) {
        this.showInTable = showInTable;
        return this;
    }
}
