package ru.yandex.direct.intapi.entity.showconditions.presentation;

import ru.yandex.direct.intapi.entity.showconditions.service.validation.ShowConditionsDefectTranslations;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.intapi.entity.showconditions.service.validation.ShowConditionsDefectIds.Gen.SIMULTANEOUS_KEYWORD_OPERATIONS;
import static ru.yandex.direct.intapi.entity.showconditions.service.validation.ShowConditionsDefectIds.Gen.SIMULTANEOUS_RELEVANCE_MATCH_OPERATIONS;
import static ru.yandex.direct.intapi.entity.showconditions.service.validation.ShowConditionsDefectIds.Gen.SIMULTANEOUS_RETARGETING_OPERATIONS;
import static ru.yandex.direct.intapi.entity.showconditions.service.validation.ShowConditionsDefectIds.Gen.SIMULTANEOUS_TARGET_INTERESTS_OPERATIONS;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;

public class ShowConditionsDefectPresentations {

    private ShowConditionsDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect>
    showConditionsDefectPresentationRegistry() {
        ShowConditionsDefectTranslations translations = ShowConditionsDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(SIMULTANEOUS_KEYWORD_OPERATIONS,
                        intapiDefect(translations.simultaneousKeywordOperations()))
                .register(SIMULTANEOUS_RETARGETING_OPERATIONS,
                        intapiDefect(translations.simultaneousRetargetingOperations()))
                .register(SIMULTANEOUS_TARGET_INTERESTS_OPERATIONS,
                        intapiDefect(translations.simultaneousTargetInterestsOperations()))
                .register(SIMULTANEOUS_RELEVANCE_MATCH_OPERATIONS,
                        intapiDefect(translations.simultaneousRelevanceMatchOperations()))
                .build();
    }
}
