package ru.yandex.direct.intapi.entity.showconditions.service.validation;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.intapi.validation.model.IntapiError;

public class ModifyIntapiValidationResult {
    private Map<Integer, ValidationContainer> addValidationInfo;
    private Map<Integer, ValidationContainer> updateValidationInfo;
    private Map<Integer, ValidationContainer> deleteValidationInfo;
    private List<IntapiError> copyAdGroupsError;

    public Map<Integer, ValidationContainer> getAddValidationInfo() {
        return addValidationInfo;
    }

    public Map<Integer, ValidationContainer> getUpdateValidationInfo() {
        return updateValidationInfo;
    }

    public Map<Integer, ValidationContainer> getDeleteValidationInfo() {
        return deleteValidationInfo;
    }

    public ModifyIntapiValidationResult withAddValidationInfo(
            Map<Integer, ValidationContainer> addValidationInfo) {
        this.addValidationInfo = addValidationInfo;
        return this;
    }

    public ModifyIntapiValidationResult withUpdateValidationInfo(
            Map<Integer, ValidationContainer> updateValidationInfo) {
        this.updateValidationInfo = updateValidationInfo;
        return this;
    }


    public ModifyIntapiValidationResult withDeleteValidationInfo(
            Map<Integer, ValidationContainer> deleteValidationInfo) {
        this.deleteValidationInfo = deleteValidationInfo;
        return this;
    }

    public List<IntapiError> getCopyAdGroupsError() {
        return copyAdGroupsError;
    }

    public ModifyIntapiValidationResult withCopyAdGroupsError(
            List<IntapiError> copyAdGroupsError) {
        this.copyAdGroupsError = copyAdGroupsError;
        return this;
    }


    /**
     * Вспомогательный класс-контейнер ддля хранения дополнительной инфы,
     * необходимый для построения результата валидации в ручке showcondition.update
     */
    public static class ValidationContainer {
        private Long adGroupId;
        private List<IntapiError> errors;

        public ValidationContainer(Long adGroupId, List<IntapiError> errors) {
            this.adGroupId = adGroupId;
            this.errors = errors;
        }

        public Long getAdGroupId() {
            return adGroupId;
        }

        public List<IntapiError> getErrors() {
            return errors;
        }
    }
}
