package ru.yandex.direct.intapi.entity.sitelink.presentation;

import ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.DUPLICATE_SITELINK_DESCS;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.DUPLICATE_SITELINK_TITLES;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.INVALID_SITELINK_HREF;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.MAX_ELEMENTS_PER_DELETE_REQUEST;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.REQUIRED_SITELINK_WITH_TURBO_HREF_OR_TURBOLANDING_ID;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.SITELINK_DESCRIPTION_CANNOT_BE_EMPTY;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.SITELINK_TITLE_CANNOT_BE_EMPTY;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_DESC;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_TITLE;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.MAX_SITELINKS_FIRST_BLOCK_TITLES_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.MAX_SITELINKS_SECOND_BLOCK_TITLES_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.MAX_SITELINKS_TITLES_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.SITELINK_DESCRIPTION_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.SITELINK_TITLE_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefectIds.Collections.SITELINKS_COUNT_MUST_BE_BETWEEN;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefectIds.Gen.DUPLICATE_SITELINK_SET;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefectIds.Gen.SITELINKS_SET_USED_AND_CANT_BE_DELETED;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;

public class SitelinkDefectPresentations {

    private SitelinkDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> sitelinkDefectPresentationRegistry() {
        SitelinkDefectTranslations translations = SitelinkDefectTranslations.INSTANCE;
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()

                //sitelinks
                .register(MAX_SITELINKS_TITLES_LENGTH,
                        defaultIntapiDefect())
                .register(MAX_SITELINKS_FIRST_BLOCK_TITLES_LENGTH,
                        defaultIntapiDefect())
                .register(MAX_SITELINKS_SECOND_BLOCK_TITLES_LENGTH,
                        defaultIntapiDefect())
                .register(ALLOWED_SYMBOLS_SITELINK_TITLE,
                        intapiDefect(translations.notAllowedSymbolsInSitelinkTitle()))
                .register(ALLOWED_SYMBOLS_SITELINK_DESC,
                        intapiDefect(translations.notAllowedSymbolsInSitelinkDesc()))
                .register(SITELINK_TITLE_CANNOT_BE_EMPTY,
                        defaultIntapiDefect())
                .register(SITELINK_DESCRIPTION_CANNOT_BE_EMPTY,
                        defaultIntapiDefect())
                .register(SITELINK_DESCRIPTION_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())
                .register(INVALID_SITELINK_HREF,
                        defaultIntapiDefect())
                .register(REQUIRED_SITELINK_WITH_TURBO_HREF_OR_TURBOLANDING_ID,
                        defaultIntapiDefect())
                .register(SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())
                .register(SITELINK_TITLE_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())

                //sitelinkSets
                .register(SITELINKS_SET_USED_AND_CANT_BE_DELETED,
                        defaultIntapiDefect())
                .register(DUPLICATE_SITELINK_TITLES,
                        intapiDefect(translations.duplicateSitelinkTitles()))
                .register(DUPLICATE_SITELINK_DESCS,
                        intapiDefect(translations.duplicateSitelinkDescs()))
                .register(MAX_ELEMENTS_PER_DELETE_REQUEST,
                        intapiDefect(commonTranslations.maxElementsExceededShort()))
                .register(OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST,
                        intapiDefect(commonTranslations.duplicatedObjectShort()))
                .register(DUPLICATE_SITELINK_SET,
                        intapiDefect(commonTranslations.duplicatedObjectShort()))
                .register(SITELINKS_COUNT_MUST_BE_BETWEEN,
                        defaultIntapiDefect())

                .build();
    }
}
