package ru.yandex.direct.intapi.entity.smsauth.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.core.smsauth.model.SmsAuthKey;
import ru.yandex.direct.core.smsauth.service.SmsAuthStorageService;
import ru.yandex.direct.intapi.entity.smsauth.model.CheckAuthResponse;
import ru.yandex.direct.tvm.AllowServices;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;

@RestController
@Api(tags = "smsAuth")
@RequestMapping(value = "/sms_auth")
@AllowServices(production = {DIRECT_WEB_PROD}, testing = {DIRECT_WEB_TEST, DIRECT_DEVELOPER})
public class SmsAuthController {

    private final SmsAuthStorageService smsAuthStorageService;

    @Autowired
    public SmsAuthController(SmsAuthStorageService smsAuthStorageService) {
        this.smsAuthStorageService = smsAuthStorageService;
    }

    @ApiOperation(
        value = "checkAuth",
        httpMethod = "GET",
        nickname = "checkAuth"
    )
    @ApiResponses(
        {
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
            @ApiResponse(code = 200, message = "Ok", response = CheckAuthResponse.class)
        }
    )
    @RequestMapping(path = "/check_auth", method = RequestMethod.GET)
    public WebResponse checkAuth(@RequestHeader(value = "Direct-Session-Id") String directSessionId,
                                 @RequestParam(value = "operatorUid") Long operatorUid) {
        SmsAuthKey key = SmsAuthKey.ofKeyParts(operatorUid, directSessionId);
        boolean isUserAuthenticated = smsAuthStorageService.isUserAuthenticated(key);

        return new CheckAuthResponse(isUserAuthenticated);
    }
}
