package ru.yandex.direct.intapi.entity.statistic.model;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jooq.types.ULong;

import ru.yandex.direct.intapi.entity.statistic.model.dynamic.GetDynamicStatisticsRequest;
import ru.yandex.direct.intapi.entity.statistic.model.dynamic.GetDynamicStatisticsRequestItem;
import ru.yandex.direct.intapi.entity.statistic.model.performance.GetPerformanceStatisticsRequest;
import ru.yandex.direct.intapi.entity.statistic.model.performance.GetPerformanceStatisticsRequestItem;
import ru.yandex.direct.intapi.entity.statistic.model.phrase.GetPhraseStatisticsRequest;
import ru.yandex.direct.intapi.entity.statistic.model.phrase.GetPhraseStatisticsRequestItem;
import ru.yandex.direct.intapi.entity.statistic.model.relevancematch.GetRelevanceMatchStatisticsRequest;
import ru.yandex.direct.intapi.entity.statistic.model.relevancematch.GetRelevanceMatchStatisticsRequestItem;
import ru.yandex.direct.intapi.entity.statistic.model.retargeting.GetRetargetingStatisticsRequest;
import ru.yandex.direct.intapi.entity.statistic.model.retargeting.GetRetargetingStatisticsRequestItem;
import ru.yandex.direct.ytcomponents.statistics.model.DateRange;
import ru.yandex.direct.ytcomponents.statistics.model.PhraseStatisticsRequest;
import ru.yandex.direct.ytcomponents.statistics.model.RetargetingStatisticsRequest;
import ru.yandex.direct.ytcomponents.statistics.model.ShowConditionStatisticsRequest;

public class PhraseStatisticConverter {
    private PhraseStatisticConverter() {
    }

    /**
     * Преобразует запрос в Intapi {@link GetPhraseStatisticsRequest} в набор
     * внутренних {@link PhraseStatisticsRequest}.
     */
    public static Collection<PhraseStatisticsRequest> toYtPhraseStatisticRequest(
            GetPhraseStatisticsRequest getPhraseStatisticsRequest) {
        List<PhraseStatisticsRequest> list = new ArrayList<>();
        for (GetPhraseStatisticsRequestItem item : getPhraseStatisticsRequest.getGetPhraseStatisticsRequestItems()) {
            PhraseStatisticsRequest.Builder builder = new PhraseStatisticsRequest.Builder()
                    .withCampaignId(item.getCampaignId())
                    .withAdGroupId(item.getAdGroupId())
                    .withBannerId(item.getBannerId());
            if (item.getBsPhraseIds() != null) {
                for (BigInteger bsPhraseId : item.getBsPhraseIds()) {
                    PhraseStatisticsRequest build = builder
                            .withBsPhraseId(ULong.valueOf(bsPhraseId))
                            .build();
                    list.add(build);
                }
            } else if (item.getPhraseIds() != null) {
                for (Long phraseId : item.getPhraseIds()) {
                    PhraseStatisticsRequest build = builder
                            .withPhraseId(phraseId)
                            .build();
                    list.add(build);
                }
            }
        }
        return list;
    }

    /**
     * Преобразует запрос в Intapi {@link GetRelevanceMatchStatisticsRequest} в набор
     * внутренних {@link ShowConditionStatisticsRequest}.
     */
    public static Collection<ShowConditionStatisticsRequest> toYtShowConditionStatisticRequest(
            GetRelevanceMatchStatisticsRequest request) {
        List<ShowConditionStatisticsRequest> list = new ArrayList<>();
        for (GetRelevanceMatchStatisticsRequestItem item : request.getGetRelevanceMatchStatisticsRequestItems()) {
            ShowConditionStatisticsRequest internalRequest = new ShowConditionStatisticsRequest.Builder()
                    .withCampaignId(item.getCampaignId())
                    .withAdGroupId(item.getAdGroupId())
                    .withShowConditionId(item.getRelevanceMatchId())
                    .build();
            list.add(internalRequest);
        }
        return list;
    }

    /**
     * Преобразует запрос в Intapi {@link GetDynamicStatisticsRequest} в набор
     * внутренних {@link ShowConditionStatisticsRequest}.
     */
    public static Collection<ShowConditionStatisticsRequest> toYtShowConditionStatisticRequest(
            GetDynamicStatisticsRequest request) {
        List<ShowConditionStatisticsRequest> list = new ArrayList<>();
        for (GetDynamicStatisticsRequestItem item : request.getSelectionCriteria()) {
            ShowConditionStatisticsRequest.Builder builder = new ShowConditionStatisticsRequest.Builder()
                    .withCampaignId(item.getCampaignId())
                    .withAdGroupId(item.getAdGroupId());
            for (Long dynConditionId : item.getDynamicConditionIds()) {
                ShowConditionStatisticsRequest build = builder
                        .withShowConditionId(dynConditionId)
                        .build();
                list.add(build);
            }
        }
        return list;
    }

    /**
     * Преобразует запрос в Intapi {@link GetPerformanceStatisticsRequest} в набор
     * внутренних {@link ShowConditionStatisticsRequest}.
     */
    public static Collection<ShowConditionStatisticsRequest> toYtShowConditionStatisticRequest(
            GetPerformanceStatisticsRequest request) {
        List<ShowConditionStatisticsRequest> list = new ArrayList<>();
        for (GetPerformanceStatisticsRequestItem item : request.getSelectionCriteria()) {
            ShowConditionStatisticsRequest.Builder builder = new ShowConditionStatisticsRequest.Builder()
                    .withCampaignId(item.getCampaignId())
                    .withAdGroupId(item.getAdGroupId());
            for (Long dynConditionId : item.getPerformanceFilterIds()) {
                ShowConditionStatisticsRequest build = builder
                        .withShowConditionId(dynConditionId)
                        .build();
                list.add(build);
            }
        }
        return list;
    }


    /**
     * Преобразует запрос в Intapi {@link GetRetargetingStatisticsRequest} в набор
     * внутренних {@link RetargetingStatisticsRequest}.
     */
    public static Collection<RetargetingStatisticsRequest> toYtRetargetingStatisticRequest(
            GetRetargetingStatisticsRequest request) {
        List<RetargetingStatisticsRequest> list = new ArrayList<>();
        for (GetRetargetingStatisticsRequestItem item : request.getSelectionCriteria()) {
            RetargetingStatisticsRequest.Builder builder = new RetargetingStatisticsRequest.Builder()
                    .withCampaignId(item.getCampaignId())
                    .withAdGroupId(item.getAdGroupId());
            for (Long retConditionId : item.getRetargetingConditionIds()) {
                list.add(builder.withRetargetingConditionId(retConditionId).build());
            }
        }
        return list;
    }

    public static DateRange getDateRangeFromPeriod(Period period) {
        LocalDate to = LocalDate.now();
        LocalDate from = to.minusDays(period.getDays());
        return new DateRange().withFromExclusive(from).withToInclusive(to);
    }
}
