package ru.yandex.direct.intapi.entity.statistic.model.dynamic;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

@SuppressWarnings("WeakerAccess")
public class GetDynamicStatisticsRequest {
    public static final String INTERVAL_DAYS = "interval_days";
    public static final String SELECTION_CRITERIA = "selection_criteria";

    @JsonProperty(SELECTION_CRITERIA)
    private List<GetDynamicStatisticsRequestItem> selectionCriteria;

    @JsonProperty(INTERVAL_DAYS)
    private Integer intervalDays;

    public List<GetDynamicStatisticsRequestItem> getSelectionCriteria() {
        return selectionCriteria;
    }

    public GetDynamicStatisticsRequest withSelectionCriteria(
            List<GetDynamicStatisticsRequestItem> selectionCriteria) {
        this.selectionCriteria = selectionCriteria;
        return this;
    }

    public Integer getIntervalDays() {
        return intervalDays;
    }

    public GetDynamicStatisticsRequest withIntervalDays(Integer intervalDays) {
        this.intervalDays = intervalDays;
        return this;
    }
}
