package ru.yandex.direct.intapi.entity.statistic.model.dynamic;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

@SuppressWarnings("WeakerAccess")
public class GetDynamicStatisticsRequestItem {
    public static final String CAMPAIGN_ID = "campaign_id";
    public static final String AD_GROUP_ID = "ad_group_id";
    public static final String DYNAMIC_CONDITION_IDS = "dynamic_condition_ids";

    @JsonProperty(CAMPAIGN_ID)
    private Long campaignId;
    @JsonProperty(AD_GROUP_ID)
    private Long adGroupId;
    @JsonProperty(DYNAMIC_CONDITION_IDS)
    private List<Long> dynamicConditionIds;

    public Long getCampaignId() {
        return campaignId;
    }

    public GetDynamicStatisticsRequestItem withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public GetDynamicStatisticsRequestItem withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public List<Long> getDynamicConditionIds() {
        return dynamicConditionIds;
    }

    public GetDynamicStatisticsRequestItem withDynamicConditionIds(List<Long> dynamicConditionIds) {
        this.dynamicConditionIds = dynamicConditionIds;
        return this;
    }
}
