package ru.yandex.direct.intapi.entity.statistic.model.order;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class GetOrdersStatByIntervalRequest {

    public static final String ORDER_IDS = "orderIds";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";

    private List<Long> orderIds;

    private LocalDate startDate;

    private LocalDate endDate;

    @JsonCreator
    public GetOrdersStatByIntervalRequest(
            @JsonProperty(ORDER_IDS) List<Long> orderIds,
            @JsonProperty(START_DATE) @JsonFormat(pattern = "yyyy-MM-dd") LocalDate startDate,
            @JsonProperty(END_DATE) @JsonFormat(pattern = "yyyy-MM-dd") LocalDate endDate
    ) {
        this.orderIds = orderIds;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public List<Long> getOrderIds() {
        return orderIds;
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public LocalDate getEndDate() {
        return endDate;
    }
}
