package ru.yandex.direct.intapi.entity.statistic.model.order;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.statistics.model.Period;

public class GetOrdersSumSpentRequest {

    public static final String ORDER_IDS_FIELD = "orderIds";
    public static final String PERIODS_FIELD = "periods";

    private final List<Long> orderIds;
    private final List<Period> periods;

    @JsonCreator
    public GetOrdersSumSpentRequest(@JsonProperty(ORDER_IDS_FIELD) List<Long> orderIds,
                                    @JsonProperty(PERIODS_FIELD) List<Period> periods) {
        this.orderIds = orderIds;
        this.periods = periods;
    }

    public List<Long> getOrderIds() {
        return orderIds;
    }

    public List<Period> getPeriods() {
        return periods;
    }
}
