package ru.yandex.direct.intapi.entity.statistic.model.performance;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

@SuppressWarnings("WeakerAccess")
public class GetPerformanceStatisticsRequestItem {
    public static final String CAMPAIGN_ID = "campaign_id";
    public static final String AD_GROUP_ID = "ad_group_id";
    public static final String PERFORMANCE_FILTER_IDS = "performance_filter_ids";

    @JsonProperty(CAMPAIGN_ID)
    private Long campaignId;
    @JsonProperty(AD_GROUP_ID)
    private Long adGroupId;
    @JsonProperty(PERFORMANCE_FILTER_IDS)
    private List<Long> performanceFilterIds;

    public Long getCampaignId() {
        return campaignId;
    }

    public GetPerformanceStatisticsRequestItem withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public GetPerformanceStatisticsRequestItem withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public List<Long> getPerformanceFilterIds() {
        return performanceFilterIds;
    }

    public GetPerformanceStatisticsRequestItem withPerformanceFilterIds(List<Long> performanceFilterIds) {
        this.performanceFilterIds = performanceFilterIds;
        return this;
    }
}
