package ru.yandex.direct.intapi.entity.statistic.model.retargeting;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

@SuppressWarnings("WeakerAccess")
public class GetRetargetingStatisticsRequest {
    public static final String INTERVAL_DAYS = "interval_days";
    public static final String SELECTION_CRITERIA = "selection_criteria";

    @JsonProperty(SELECTION_CRITERIA)
    private List<GetRetargetingStatisticsRequestItem> selectionCriteria;

    @JsonProperty(INTERVAL_DAYS)
    private Integer intervalDays;

    public List<GetRetargetingStatisticsRequestItem> getSelectionCriteria() {
        return selectionCriteria;
    }

    public GetRetargetingStatisticsRequest withSelectionCriteria(
            List<GetRetargetingStatisticsRequestItem> selectionCriteria) {
        this.selectionCriteria = selectionCriteria;
        return this;
    }

    public Integer getIntervalDays() {
        return intervalDays;
    }

    public GetRetargetingStatisticsRequest withIntervalDays(Integer intervalDays) {
        this.intervalDays = intervalDays;
        return this;
    }
}
