package ru.yandex.direct.intapi.entity.statistic.model.retargeting;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

@SuppressWarnings("WeakerAccess")
public class GetRetargetingStatisticsRequestItem {
    public static final String CAMPAIGN_ID = "campaign_id";
    public static final String AD_GROUP_ID = "ad_group_id";
    public static final String RETARGETING_CONDITION_IDS = "retargeting_condition_ids";

    @JsonProperty(CAMPAIGN_ID)
    private Long campaignId;
    @JsonProperty(AD_GROUP_ID)
    private Long adGroupId;
    @JsonProperty(RETARGETING_CONDITION_IDS)
    private List<Long> retargetingConditionIds;

    public Long getCampaignId() {
        return campaignId;
    }

    public GetRetargetingStatisticsRequestItem withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public GetRetargetingStatisticsRequestItem withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public List<Long> getRetargetingConditionIds() {
        return retargetingConditionIds;
    }

    public GetRetargetingStatisticsRequestItem withRetargetingConditionIds(List<Long> retargetingConditionIds) {
        this.retargetingConditionIds = retargetingConditionIds;
        return this;
    }
}
