package ru.yandex.direct.intapi.entity.strategy.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class JsonStrategy {
    private Long isNetStop;
    private String name;
    private JsonStrategy search;
    private JsonStrategy net;
    private BigDecimal sum;
    private BigDecimal avgBid;
    private BigDecimal avgCpa;
    private BigDecimal bid;
    private Long goalId;
    private BigDecimal roiCoef;
    private BigDecimal profitability;
    private Long reserveReturn;
    private Long limitClicks;
    private Boolean payForConversion;

    public Long getIsNetStop() {
        return isNetStop;
    }

    public JsonStrategy setIsNetStop(Long isNetStop) {
        this.isNetStop = isNetStop;
        return this;
    }

    public String getName() {
        return name;
    }

    public JsonStrategy setName(String name) {
        this.name = name;
        return this;
    }

    public JsonStrategy getSearch() {
        return search;
    }

    public JsonStrategy setSearch(JsonStrategy search) {
        this.search = search;
        return this;
    }

    public JsonStrategy getNet() {
        return net;
    }

    public JsonStrategy setNet(JsonStrategy net) {
        this.net = net;
        return this;
    }

    public BigDecimal getSum() {
        return sum;
    }

    public JsonStrategy setSum(BigDecimal sum) {
        this.sum = sum;
        return this;
    }

    public BigDecimal getAvgBid() {
        return avgBid;
    }

    public JsonStrategy setAvgBid(BigDecimal avgBid) {
        this.avgBid = avgBid;
        return this;
    }

    public BigDecimal getAvgCpa() {
        return avgCpa;
    }

    public JsonStrategy setAvgCpa(BigDecimal avgCpa) {
        this.avgCpa = avgCpa;
        return this;
    }

    public BigDecimal getBid() {
        return bid;
    }

    public JsonStrategy setBid(BigDecimal bid) {
        this.bid = bid;
        return this;
    }

    public Long getGoalId() {
        return goalId;
    }

    public JsonStrategy setGoalId(Long goalId) {
        this.goalId = goalId;
        return this;
    }

    public BigDecimal getRoiCoef() {
        return roiCoef;
    }

    public JsonStrategy setRoiCoef(BigDecimal roiCoef) {
        this.roiCoef = roiCoef;
        return this;
    }

    public BigDecimal getProfitability() {
        return profitability;
    }

    public JsonStrategy setProfitability(BigDecimal profitability) {
        this.profitability = profitability;
        return this;
    }

    public Long getReserveReturn() {
        return reserveReturn;
    }

    public JsonStrategy setReserveReturn(Long reserveReturn) {
        this.reserveReturn = reserveReturn;
        return this;
    }

    public Long getLimitClicks() {
        return limitClicks;
    }

    public JsonStrategy setLimitClicks(Long limitClicks) {
        this.limitClicks = limitClicks;
        return this;
    }

    public Boolean getPayForConversion() {
        return payForConversion;
    }

    public void setPayForConversion(Boolean payForConversion) {
        this.payForConversion = payForConversion;
    }
}
