package ru.yandex.direct.intapi.entity.strategy.model;

import ru.yandex.direct.core.entity.campaign.model.CampOptionsStrategy;
import ru.yandex.direct.core.entity.campaign.model.CampaignsAutobudget;
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.utils.JsonUtils;

public class SaveStrategyRequestConverter {
    private SaveStrategyRequestConverter() {
    }

    public static DbStrategy toDbStrategy(SaveStrategyRequest req) {
        JsonStrategy jsonStrategy = JsonUtils.fromJson(req.getJsonStrategy(), JsonStrategy.class);
        var strategy = new DbStrategy();
        strategy.setAutobudget(getCampaignsAutobudget(jsonStrategy));
        strategy.setPlatform(getPlatform(jsonStrategy));
        strategy.setStrategy(getCampOptionsStrategy(jsonStrategy));
        strategy.setStrategyName(getStrategyName(jsonStrategy));
        strategy.setStrategyData(getStrategyData(jsonStrategy));
        return strategy;
    }

    private static CampaignsAutobudget getCampaignsAutobudget(JsonStrategy json) {
        return getStrategyName(json).name().toLowerCase().contains("autobudget")
                ? CampaignsAutobudget.YES
                : CampaignsAutobudget.NO;
    }

    private static StrategyName getStrategyName(JsonStrategy json) {
        for (StrategyName name : StrategyName.values()) {
            if (name.name().equalsIgnoreCase(json.getSearch().getName())
                    || name.name().equalsIgnoreCase(json.getNet().getName())) {
                return name;
            }
        }
        return StrategyName.DEFAULT_;
    }

    private static CampOptionsStrategy getCampOptionsStrategy(JsonStrategy json) {
        for (CampOptionsStrategy campOptionsStrategy : CampOptionsStrategy.values()) {
            if (json.getName().equalsIgnoreCase(campOptionsStrategy.name())) {
                return campOptionsStrategy;
            }
        }
        return null;
    }

    private static CampaignsPlatform getPlatform(JsonStrategy json) {
        if (json.getIsNetStop() != null && json.getIsNetStop().equals(1L)) {
            return CampaignsPlatform.SEARCH;
        }
        return json.getSearch().getName().equalsIgnoreCase("stop") ? CampaignsPlatform.CONTEXT : CampaignsPlatform.BOTH;
    }

    private static StrategyData getStrategyData(JsonStrategy json) {
        JsonStrategy src = getPlatform(json) == CampaignsPlatform.CONTEXT ? json.getNet() : json.getSearch();
        String strategyName = getStrategyName(json).name().toLowerCase();
        if (strategyName.equals("default_")) {
            strategyName = "default";
        }
        return new StrategyData().withVersion(1L)
                .withSum(src.getSum())
                .withName(strategyName)
                .withAvgBid(src.getAvgBid())
                .withGoalId(src.getGoalId())
                .withBid(src.getBid())
                .withAvgCpa(src.getAvgCpa())
                .withRoiCoef(src.getRoiCoef())
                .withProfitability(src.getProfitability())
                .withReserveReturn(src.getReserveReturn())
                .withLimitClicks(src.getLimitClicks())
                .withPayForConversion(src.getPayForConversion());
    }
}
