package ru.yandex.direct.intapi.entity.strategy.model;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.intapi.validation.model.IntapiResponse;

public class StrategyResponse implements IntapiResponse {
    private List<String> errors = new ArrayList<>();
    private boolean isSuccessful = true;

    public StrategyResponse() {
    }

    public StrategyResponse(List<String> errors, boolean isSuccessful) {
        this.errors = errors;
        this.isSuccessful = isSuccessful;
    }

    @Override
    public boolean isSuccessful() {
        return isSuccessful;
    }

    public List<String> getError() {
        return errors;
    }

    public static StrategyResponse failed(String error) {
        return new StrategyResponse(ImmutableList.of(error), false);
    }
}
