package ru.yandex.direct.intapi.entity.takeout;

import javax.ws.rs.core.MediaType;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.takeout.service.TakeoutService;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.takeout.model.DataResponse;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.TAKEOUT_PROD;
import static ru.yandex.direct.tvm.TvmService.TAKEOUT_TEST;

@Controller
@RequestMapping("takeout")
@Api(value = "Интергация с takeout")
@AllowServices(production = TAKEOUT_PROD, testing = {TAKEOUT_TEST, DIRECT_DEVELOPER})
public class TakeoutController {

    private final TakeoutService takeoutService;

    public TakeoutController(TakeoutService takeoutService) {
        this.takeoutService = takeoutService;
    }

    @ApiOperation(
            value = "Запрос на выгрузку данных в takeout",
            notes = "",
            httpMethod = "POST",
            nickname = "request"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params",
                            response = ErrorResponse.class),
                    @ApiResponse(code = 403, message = "permission denied",
                            response = ErrorResponse.class)
            }

    )
    @RequestMapping(path = "request",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_FORM_URLENCODED,
            produces = MediaType.APPLICATION_JSON
    )
    @ResponseBody
    public DataResponse requestData(
            @ApiParam(value = "uid пользователя", required = true)
            @RequestParam("uid") long uid,
            @ApiParam(value = "id задачи, который генерируется на стороне тейкаута и " +
                    "который надо передавать обратно тейкауту", required = true)
            @RequestParam("job_id") String jobId,
            @ApiParam(value = "время запроса данных пользователем")
            @RequestParam(value = "unixtime", required = false) Long unixTime
    ) {
        takeoutService.requestData(uid, jobId, unixTime);
        return DataResponse.OK;
    }
}
