package ru.yandex.direct.intapi.entity.tracelogs.model.profilestats;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс, объекты которого будут сериализовываться в JSON в элементы массива "data", если
 * GROUP BY включал в себя столбцы profile.func или profile.tags
 */
@ParametersAreNonnullByDefault
public class FuncProfileData extends ProfileData {
    @JsonProperty("func_cnt")
    private long funcCnt;

    @JsonProperty("func_ela")
    private double funcEla;

    @JsonProperty("func_obj_num")
    private long funcObjNum;

    @JsonProperty("func_ela_avg")
    private double funcElaAvg;

    @JsonProperty("func_obj_ela_avg")
    private double funcObjElaAvg;

    public FuncProfileData(long funcCnt, double funcEla, long funcObjNum, double funcElaAvg, double funcObjElaAvg) {
        this.funcCnt = funcCnt;
        this.funcEla = funcEla;
        this.funcObjNum = funcObjNum;
        this.funcElaAvg = funcElaAvg;
        this.funcObjElaAvg = funcObjElaAvg;
    }
}
