package ru.yandex.direct.intapi.entity.tracelogs.model.profilestats;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Поля, по которым может быть выполнена операция GROUP BY Trace логов
 */
public enum GroupByField {
    @JsonProperty("stat_time")
    STAT_TIME("stat_time"),

    @JsonProperty("cmd_type")
    CMD_TYPE("service"),

    @JsonProperty("cmd")
    CMD("method"),

    @JsonProperty("tags")
    TAGS("tags"),

    @JsonProperty("host_name")
    HOST_NAME("host"),

    @JsonProperty("func")
    FUNC("profile.func"),

    @JsonProperty("func_param")
    FUNC_PARAM("profile.tags");

    private String sqlValue;

    GroupByField(String sqlValue) {
        this.sqlValue = sqlValue;
    }

    public String getSqlValue() {
        return sqlValue;
    }
}
