package ru.yandex.direct.intapi.entity.tracelogs.model.profilestats;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;

/**
 * Класс, содержащий возможные общие поля в JSON'е в элементах массива "data"
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonSubTypes({
        @JsonSubTypes.Type(value = FuncProfileData.class),
        @JsonSubTypes.Type(value = StatsProfileData.class)
})
public abstract class ProfileData {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @JsonProperty("stat_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime statTime;

    @JsonProperty("host_name")
    private String hostName;

    @JsonProperty("cmd_type")
    private String cmdType;

    @JsonProperty("cmd")
    private String cmd;

    @JsonProperty("tags")
    private String tags;

    @JsonProperty("func")
    private String func;

    @JsonProperty("func_param")
    private String funcParam;

    public void setStatTime(LocalDateTime statTime) {
        this.statTime = statTime;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setCmdType(String cmdType) {
        this.cmdType = cmdType;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setFunc(String func) {
        this.func = func;
    }

    public void setFuncParam(String funcParam) {
        this.funcParam = funcParam;
    }
}
