package ru.yandex.direct.intapi.entity.tracelogs.model.profilestats;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.utils.DateTimeUtils.MSK;

/**
 * Класс, который десериализуется из поданного JSON'a на вход ручке
 */
public class ProfileStatsRequest {
    private static final ZoneId DEFAULT_TIMEZONE = MSK;
    private static final int DEFAULT_TIME_AGG = 3600;

    @JsonProperty(value = "time_agg")
    private Long timeAgg;

    @JsonProperty("group_by")
    private List<GroupByField> groupBy;

    @JsonProperty("filters")
    private Map<FilterField, List<String>> filters;

    @JsonProperty("time_period")
    private Long timePeriod;

    @JsonProperty("time_from")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime timeFrom;

    @JsonProperty("time_to")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime timeTo;

    @JsonProperty("timezone")
    private ZoneId timeZone;

    public long getTimeAgg() {
        return timeAgg == null ? DEFAULT_TIME_AGG : timeAgg;
    }

    public List<GroupByField> getGroupBy() {
        return groupBy;
    }

    public Map<FilterField, List<String>> getFilters() {
        return filters;
    }

    public Long getTimePeriod() {
        return timePeriod;
    }

    public LocalDateTime getTimeFrom() {
        return timeFrom;
    }

    public LocalDateTime getTimeTo() {
        return timeTo;
    }

    public ZoneId getTimeZone() {
        return timeZone == null ? DEFAULT_TIMEZONE : timeZone;
    }
}
