package ru.yandex.direct.intapi.entity.tracelogs.model.profilestats;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс, который сериализуется в JSON для ответа ручки
 */
public class ProfileStatsResponse {
    @JsonProperty("error")
    private String error;

    @JsonProperty("result")
    private Result result;

    public ProfileStatsResponse(String error, List<ResultField> fields, List<ProfileData> data) {
        this.error = error;
        this.result = new Result(fields, data);
    }

    public Result getResult() {
        return result;
    }

    public String getError() {
        return error;
    }

    public static class Result {
        @JsonProperty("fields")
        List<ResultField> fields;

        @JsonProperty("data")
        List<ProfileData> data;

        private Result(List<ResultField> fields, List<ProfileData> data) {
            this.fields = fields;
            this.data = data;
        }
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class ResultField {
        @JsonProperty("title")
        String title;

        @JsonProperty("id")
        String id;

        @JsonProperty("text_sort")
        Boolean textSort;

        public ResultField(String title, String id, Boolean textSort) {
            this.title = title;
            this.id = id;
            this.textSort = textSort;
        }

        public ResultField(String title, String id) {
            this(title, id, null);
        }
    }
}
