package ru.yandex.direct.intapi.entity.tracelogs.model.profilestats;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс, объекты которого будут сериализовываться в JSON в элементы массива "data", если
 * GROUP BY не включал в себя ни profile.func, ни profile.tags
 */
@ParametersAreNonnullByDefault
public class StatsProfileData extends ProfileData {
    @JsonProperty("ela")
    private double ela;

    @JsonProperty("cpu_user")
    private double cpuUser;

    @JsonProperty("cpu_system")
    private double cpuSystem;

    @JsonProperty("mem")
    private double mem;

    @JsonProperty("cnt")
    private long cnt;

    @JsonProperty("ela_avg")
    private double elaAvg;

    public StatsProfileData(double ela, double cpuUser, double cpuSystem, double mem, long cnt, double elaAvg) {
        this.ela = ela;
        this.cpuUser = cpuUser;
        this.cpuSystem = cpuSystem;
        this.mem = mem;
        this.cnt = cnt;
        this.elaAvg = elaAvg;
    }
}
