package ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс, объекты которого сериализуются в JSON в элементы массива "cmds"
 */
public class Cmd extends StatsElement {
    @JsonProperty("cmd_type")
    private String cmdType;

    @JsonProperty("cmd")
    private String cmd;

    @JsonProperty("cnt")
    private int cnt;

    @JsonProperty("ela")
    private double ela;

    @JsonProperty("cpu_user")
    private double cpuUser;

    @JsonProperty("cpu_system")
    private double cpuSystem;

    @JsonProperty("mem")
    private float mem;

    @SuppressWarnings("checkstyle:parameternumber")
    public Cmd(List<Integer> cmdMatch, LocalDate date, String cmdType, String cmd,
               int cnt, double ela, double cpuUser, double cpuSystem, float mem) {
        super(cmdMatch, date);

        this.cmdType = cmdType;
        this.cmd = cmd;
        this.cnt = cnt;
        this.ela = ela;
        this.cpuUser = cpuUser;
        this.cpuSystem = cpuSystem;
        this.mem = mem;
    }

    public int getCnt() {
        return cnt;
    }

    public void addCnt(int cnt) {
        this.cnt += cnt;
    }
}
