package ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

/**
 * Класс, содержащий в себе данные по {@link Cmd} и по {@link Summary}
 */
public class CmdsSummary extends StatsElement {
    private String cmdType;
    private String cmd;
    private double ela;
    private double cpuUser;
    private double cpuSystem;
    private float mem;
    private int cnt;
    private float roundedEla;

    @SuppressWarnings("checkstyle:parameternumber")
    public CmdsSummary(List<Integer> cmdMatch, LocalDate date, String cmdType, String cmd, double ela, double cpuUser,
                       double cpuSystem, float mem, int cnt, float roundedEla) {
        super(cmdMatch, date);
        this.cmdType = cmdType;
        this.cmd = cmd;
        this.ela = ela;
        this.cpuUser = cpuUser;
        this.cpuSystem = cpuSystem;
        this.mem = mem;
        this.cnt = cnt;
        this.roundedEla = roundedEla;
    }

    public Summary getSummary() {
        return new Summary(getCmdMatch(), getDate(), roundedEla, cnt);
    }

    public Cmd getCmd() {
        return new Cmd(getCmdMatch(), getDate(), cmdType, cmd, cnt, ela, cpuUser, cpuSystem, mem);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }

        CmdsSummary other = (CmdsSummary) obj;
        return this.getDate().equals(other.getDate())
                && this.cmdType.equals(other.cmdType)
                && this.cmd.equals(other.cmd);
    }

    @Override
    public int hashCode() {
        return Objects.hash(getDate(), getCmdMatch(), cmdType, cmd);
    }
}
