package ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.utils.DateTimeUtils.MSK;

/**
 * Класс, который десериализуется из поданного JSON'a на вход ручке
 */
public class ProfileStatsByElaRequest {
    private static final ZoneId DEFAULT_TIMEZONE = MSK;

    @JsonProperty("date_from")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate dateFrom;

    @JsonProperty("date_to")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate dateTo;

    @JsonProperty("compare_dates")
    private Boolean compareDates;

    @JsonProperty("regexps")
    private List<String> regexps;

    @JsonProperty("boundaries")
    private List<Float> boundaries;

    @JsonProperty("timezone")
    private ZoneId timezone;

    public LocalDate getDateFrom() {
        return dateFrom;
    }

    public LocalDate getDateTo() {
        return dateTo;
    }

    public boolean isCompareDates() {
        return compareDates != null && compareDates;
    }

    public List<String> getRegexps() {
        return regexps;
    }

    public List<Float> getBoundaries() {
        return boundaries;
    }

    public ZoneId getTimezone() {
        return timezone == null ? DEFAULT_TIMEZONE : timezone;
    }
}
