package ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс, который сериализуется в JSON для ответа ручки
 */
public class ProfileStatsByElaResponse {
    @JsonProperty("error")
    private String error;

    @JsonProperty("result")
    private Result result;

    public ProfileStatsByElaResponse(String error, List<Stats> stats) {
        this.error = error;
        this.result = new Result(stats);
    }

    public static class Result {
        @JsonProperty("stats")
        private List<Stats> stats;

        public Result(List<Stats> stats) {
            this.stats = stats;
        }
    }

    public static class Stats {
        @JsonProperty("regexp")
        private String regexp;

        @JsonProperty("date")
        @JsonFormat(pattern = "yyyy-MM-dd")
        private LocalDate date;

        @JsonProperty("cmds")
        private List<Cmd> cmds;

        @JsonProperty("summary")
        private List<Summary> summary;

        @JsonProperty("funcs_ela")
        private Map<String, Map<String, Float>> funcsEla;

        public Stats(String regexp, LocalDate date) {
            this.regexp = regexp;
            this.date = date;
            this.cmds = new ArrayList<>();
            this.summary = new ArrayList<>();
            this.funcsEla = new HashMap<>();
        }

        public Stats(
                String regexp, LocalDate date, List<Cmd> cmds, List<Summary> summary,
                Map<String, Map<String, Float>> funcsEla
        ) {
            this.regexp = regexp;
            this.date = date;
            this.cmds = cmds;
            this.summary = summary;
            this.funcsEla = funcsEla;
        }
    }
}
