package ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Класс, содержащий общие поля для классов {@link Cmd}, {@link Summary} и {@link FuncStats}
 */
public abstract class StatsElement {
    @JsonIgnore
    private List<Integer> cmdMatch;

    @JsonIgnore
    private LocalDate date;

    public StatsElement(List<Integer> cmdMatch, LocalDate date) {
        this.cmdMatch = cmdMatch;
        this.date = date;
    }

    public List<Integer> getCmdMatch() {
        return cmdMatch;
    }

    public LocalDate getDate() {
        return date;
    }
}
