package ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс, объекты которого сериализуются в JSON в элементы массива "summary"
 */
public class Summary extends StatsElement {
    @JsonProperty("rounded_ela")
    private float roundedEla;

    @JsonProperty("cnt")
    private int cnt;

    public Summary(List<Integer> cmdMatch, LocalDate date, float roundedEla, int cnt) {
        super(cmdMatch, date);

        this.roundedEla = roundedEla;
        this.cnt = cnt;
    }

    public float getRoundedEla() {
        return roundedEla;
    }

    public long getCnt() {
        return cnt;
    }

    public void addCnt(long cnt) {
        this.cnt += cnt;
    }
}
