package ru.yandex.direct.intapi.entity.tracelogs.service.profilestats;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.direct.intapi.entity.tracelogs.model.profilestats.FuncProfileData;
import ru.yandex.direct.intapi.entity.tracelogs.model.profilestats.ProfileData;
import ru.yandex.direct.intapi.entity.tracelogs.model.profilestats.StatsProfileData;

import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.CNT;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.CPU_SYSTEM;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.CPU_USER;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.ELA;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.FUNC_CNT;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.FUNC_ELA;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.FUNC_OBJ_NUM;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.FUNC_OBJ_NUM_1;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestats.ProfileStatsService.MEM;

/**
 * Класс, отображающий строку из запроса бд в {@link ProfileData}
 */
public class ProfileStatsRowMapper implements RowMapper<ProfileData> {
    private static final String STAT_TIME = "stat_time";
    private static final String FUNC = "func";
    private static final String FUNC_PARAM = "func_param";
    private static final String CMD_TYPE = "cmd_type";
    private static final String CMD = "cmd";
    private static final String TAGS = "tags";
    private static final String HOST_NAME = "host_name";

    private boolean useFuncs;

    public ProfileStatsRowMapper() {
        this.useFuncs = false;
    }

    public boolean isUseFuncs() {
        return useFuncs;
    }

    public void setUseFuncs(boolean useFuncs) {
        this.useFuncs = useFuncs;
    }

    @Override
    public ProfileData mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();

        ProfileData data;
        if (useFuncs) {
            long funcCnt = rs.getLong(FUNC_CNT);
            double funcEla = rs.getDouble(FUNC_ELA);
            long funcObjNum1 = rs.getLong(FUNC_OBJ_NUM_1);
            double funcElaAvg = funcEla / (funcCnt == 0 ? 1 : funcCnt);
            double funcObjElaAvg = funcEla / (funcObjNum1 == 0 ? 1 : funcObjNum1);
            long funcObjNum = rs.getLong(FUNC_OBJ_NUM);

            data = new FuncProfileData(funcCnt, funcEla, funcObjNum, funcElaAvg, funcObjElaAvg);
        } else {
            long cnt = rs.getLong(CNT);
            double ela = rs.getDouble(ELA);
            double elaAvg = ela / (cnt == 0 ? 1 : cnt);
            double cpuUser = rs.getDouble(CPU_USER);
            double cpuSystem = rs.getDouble(CPU_SYSTEM);
            double mem = rs.getDouble(MEM);

            data = new StatsProfileData(ela, cpuUser, cpuSystem, mem, cnt, elaAvg);
        }

        for (int i = 1; i <= metaData.getColumnCount(); i++) {
            switch (metaData.getColumnName(i)) {
                case STAT_TIME:
                    data.setStatTime(rs.getTimestamp(STAT_TIME).toLocalDateTime());
                    break;
                case FUNC:
                    data.setFunc(rs.getString(FUNC));
                    break;
                case FUNC_PARAM:
                    data.setFuncParam(rs.getString(FUNC_PARAM));
                    break;
                case CMD_TYPE:
                    data.setCmdType(rs.getString(CMD_TYPE));
                    break;
                case CMD:
                    data.setCmd(rs.getString(CMD));
                    break;
                case TAGS:
                    data.setCmd(rs.getString(TAGS));
                    break;
                case HOST_NAME:
                    data.setHostName(rs.getString(HOST_NAME));
                    break;
                default:
                    break;
            }
        }

        return data;
    }
}
