package ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela.CmdsSummary;

import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.CMD;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.CMD_TYPE;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.CNT;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.CPU_SYSTEM;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.CPU_USER;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.ELA_SUM;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.LOG_DATE;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.MEM;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.ROUNDED_ELA;

/**
 * Класс, отображающий строку из запроса бд в {@link CmdsSummary}
 */
public class CmdSummaryRowMapper implements RowMapper<CmdsSummary> {
    private List<String> regexpNames;

    public CmdSummaryRowMapper(List<String> regexpNames) {
        this.regexpNames = regexpNames;
    }

    @Override
    public CmdsSummary mapRow(ResultSet rs, int rowNum) throws SQLException {
        List<Integer> cmdMatch = new ArrayList<>();
        for (String regexpName : regexpNames) {
            cmdMatch.add(rs.getInt(regexpName));
        }

        LocalDate date = rs.getDate(LOG_DATE).toLocalDate();
        String cmdType = rs.getString(CMD_TYPE);
        String cmd = rs.getString(CMD);
        float roundedEla = rs.getFloat(ROUNDED_ELA);
        int cnt = rs.getInt(CNT);
        double ela = rs.getDouble(ELA_SUM);
        double cpuUser = rs.getDouble(CPU_USER);
        double cpuSystem = rs.getDouble(CPU_SYSTEM);
        float mem = rs.getFloat(MEM);

        return new CmdsSummary(cmdMatch, date, cmdType, cmd, ela, cpuUser, cpuSystem, mem, cnt, roundedEla);
    }
}
