package ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.direct.intapi.entity.tracelogs.model.profilestatsbyela.FuncStats;

import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.ELA_PROC;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.FUNC_PARAM;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.LOG_DATE;
import static ru.yandex.direct.intapi.entity.tracelogs.service.profilestatsbyela.ProfileStatsByElaService.ROUNDED_ELA;

/**
 * Класс, отображающий строку из запроса бд в {@link FuncStats}
 */
public class FuncRowMapper implements RowMapper<FuncStats> {
    private List<String> regexpNames;

    public FuncRowMapper(List<String> regexpNames) {
        this.regexpNames = regexpNames;
    }

    @Override
    public FuncStats mapRow(ResultSet rs, int rowNum) throws SQLException {
        List<Integer> cmdMatch = new ArrayList<>();
        for (String regexpName : regexpNames) {
            cmdMatch.add(rs.getInt(regexpName));
        }

        LocalDate date = rs.getDate(LOG_DATE).toLocalDate();
        String funcParam = rs.getString(FUNC_PARAM);
        float roundedEla = rs.getFloat(ROUNDED_ELA);
        float elaProc = rs.getFloat(ELA_PROC);

        return new FuncStats(cmdMatch, date, funcParam, roundedEla, elaProc);
    }
}
