package ru.yandex.direct.intapi.entity.turboecom.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import ru.yandex.direct.balance.client.exception.BalanceClientException;
import ru.yandex.direct.balance.client.model.request.createtransfermultiple.CreateTransferMultipleRequest;
import ru.yandex.direct.core.service.integration.balance.BalanceService;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.IntApiException;
import ru.yandex.direct.intapi.entity.turboecom.model.TransferMoneyRequest;
import ru.yandex.direct.intapi.entity.turboecom.model.TransferMoneyResponse;

@Service
public class TurboEcomService {

    private static final Logger logger = LoggerFactory.getLogger(TurboEcomService.class);

    private final BalanceService balanceService;
    private final TransferMoneyRequestConverter requestConverter;

    @Autowired
    public TurboEcomService(BalanceService balanceService, TransferMoneyRequestConverter requestConverter) {
        this.balanceService = balanceService;
        this.requestConverter = requestConverter;
    }

    public TransferMoneyResponse transferMoney(TransferMoneyRequest transferMoneyRequest) {
        CreateTransferMultipleRequest balanceRequest = requestConverter.convert(transferMoneyRequest);

        try {
            balanceService.createTransferMultiple(balanceRequest);
            return new TransferMoneyResponse(true);
        } catch (BalanceClientException balanceException) {
            logger.error(
                    String.format("Failed to transfer money from client: %s to clients: %s for operator: %s",
                            transferMoneyRequest.getClientIdFrom(),
                            transferMoneyRequest.getClientIdsTo(),
                            transferMoneyRequest.getOperatorUid()),
                    balanceException);
            throw new IntApiException(HttpStatus.INTERNAL_SERVER_ERROR,
                    new ErrorResponse(ErrorResponse.ErrorCode.INTERNAL_ERROR, "BalanceException"));
        }
    }
}
