package ru.yandex.direct.intapi.entity.turbolandings;

import java.util.List;

import javax.annotation.Nonnull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.core.MediaType;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.common.logging.EventType;
import ru.yandex.direct.common.logging.LoggingConfig;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.turbolandings.model.IntapiTurboLanding;
import ru.yandex.direct.intapi.entity.turbolandings.model.TurboLandingInfoResponse;
import ru.yandex.direct.intapi.entity.turbolandings.model.UpdateCounterGrantsIntapiRequestItem;
import ru.yandex.direct.intapi.entity.turbolandings.service.TurboLandingsService;
import ru.yandex.direct.intapi.logging.ClientIdParam;
import ru.yandex.direct.intapi.logging.OperatorUid;
import ru.yandex.direct.intapi.validation.model.IntapiResponse;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_PROD;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_TEST;

@RestController
@RequestMapping("turboLandings")
@Api(tags = "intapiTurboLandings", value = "работа с данными турбо-страниц")
public class TurboLandingsController {

    private final TurboLandingsService turboLandingsService;

    @Autowired
    public TurboLandingsController(
            TurboLandingsService turboLandingsService
    ) {
        this.turboLandingsService = turboLandingsService;
    }

    @POST
    @ApiOperation(
            value = "обновление для указаных счетчиков метрики прав доступа",
            nickname = "updateCounterGrants",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = "update_counter_grants",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON,
            produces = MediaType.APPLICATION_JSON
    )
    @AllowServices(
            production = {DIRECT_WEB_PROD},
            testing = {DIRECT_WEB_TEST, DIRECT_DEVELOPER})
    @LoggingConfig(logRequestBody = EventType.ALL, logResponseBody = EventType.ALL)
    public IntapiResponse updateCounterGrants(
            @RequestParam(value = "operator_uid") @OperatorUid Long operatorUid,
            @RequestBody @Nonnull List<UpdateCounterGrantsIntapiRequestItem> request
    ) {
        return turboLandingsService.updateCounterGrants(operatorUid, request);
    }

    @POST
    @ApiOperation(
            value = "сохранение в БД переданного турболендинга",
            nickname = "saveTurbolanding",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = "save_turbolanding",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON,
            produces = MediaType.APPLICATION_JSON
    )
    @AllowServices(
            production = {LPC_SWITCHCONSTRUCTOR_PROD, DIRECT_INTAPI_PROD},
            testing = {LPC_SWITCHCONSTRUCTOR_TEST, DIRECT_INTAPI_TEST, DIRECT_DEVELOPER})
    @LoggingConfig(logRequestBody = EventType.ALL, logResponseBody = EventType.ALL)
    public IntapiResponse saveTurbolanding(
            @RequestParam(value = "operator_uid") @OperatorUid long operatorUid,
            @RequestParam(value = "client_id") @ClientIdParam long clientId,
            @RequestBody @Nonnull List<IntapiTurboLanding> turboLandings) {
        return turboLandingsService.saveTurboLanding(operatorUid, ClientId.fromLong(clientId), turboLandings);
    }


    @GET
    @ApiOperation(
            value = "получение привязок указанной турбо-страницы",
            nickname = "get_turbolanding_info",
            httpMethod = "GET"
    )
    @ApiResponses(
            @ApiResponse(code = 400, message = "Не найден оператор или клиент",
                    response = ErrorResponse.class)
    )
    @RequestMapping(path = "get_turbolanding_info",
            method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON
    )
    @AllowServices(
            production = {LPC_SWITCHCONSTRUCTOR_PROD},
            testing = {LPC_SWITCHCONSTRUCTOR_TEST, DIRECT_DEVELOPER})
    @LoggingConfig(logRequestBody = EventType.ALL, logResponseBody = EventType.ALL)
    public TurboLandingInfoResponse getTurbolandingInfo(
            @ApiParam(value = "текущий паспортный uid пользователя из конструктора креативов")
            @RequestParam(value = "user_id") @OperatorUid long operatorUid,

            @ApiParam(value = "id клиента из баланса")
            @RequestParam(value = "client_id") @ClientIdParam long clientId,

            @ApiParam(value = "id турбо-страницы")
            @RequestParam(value = "tl_id") Long turbolandingId

    ) {
        return turboLandingsService.getTurboLandingInfo(operatorUid, ClientId.fromLong(clientId), turbolandingId);
    }

}
