package ru.yandex.direct.intapi.entity.turbolandings.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.intapi.validation.model.IntapiResponse;

import static ru.yandex.direct.utils.JsonUtils.toJson;

@ApiModel
public class EnrichTurboLandingsResponse implements IntapiResponse {
    @JsonProperty("turbolandings")
    private Map<Long, ItemTurboLanding> turbolandingsMap;

    public EnrichTurboLandingsResponse() {
    }

    @ApiModel
    public static class ItemTurboLanding {
        private Long id;
        private String name;
        private String href;
        @JsonRawValue
        private String counters;

        ItemTurboLanding(TurboLanding turboLanding) {
            this.id = turboLanding.getId();
            this.name = turboLanding.getName();
            this.href = turboLanding.getUrl();
            this.counters = turboLanding.getMetrikaCounters();
        }

        public ItemTurboLanding() {
        }

        @ApiModelProperty(value = "id турболендинга", required = true, name = "id")
        public long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        @ApiModelProperty(value = "имя турболендинга", required = true, name = "name")
        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ApiModelProperty(value = "ссылка на турболендинг", required = true, name = "href")
        public String getHref() {
            return href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        @ApiModelProperty(value = "счетчики и цели метрики", required = true, name = "counters")
        public String getCounters() {
            return counters;
        }

        public void setCounters(String counters) {
            this.counters = counters;
        }

        @JsonSetter("counters")
        public void makeCountersFromList(List<Object> countersList) {
            this.counters = toJson(countersList);
        }
    }

    public EnrichTurboLandingsResponse(List<TurboLanding> turboLandings) {
        this.turbolandingsMap = new HashMap<>();
        turboLandings.forEach(t -> this.turbolandingsMap.put(t.getId(), new ItemTurboLanding(t)));
    }

    @ApiModelProperty(
            value = "турболендинги клиента",
            required = true,
            name = "turbolandings"
    )
    public Map<Long, ItemTurboLanding> getTurbolandings() {
        return turbolandingsMap;
    }

    public void setTurbolandings(Map<Long, ItemTurboLanding> turbolandingsMap) {
        this.turbolandingsMap = turbolandingsMap;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }
}
