package ru.yandex.direct.intapi.entity.turbolandings.model;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

public class IntapiTurboLanding {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String COUNTERS = "counters";
    public static final String VERSION = "version";
    public static final String PREVIEW_HREF = "previewHref";
    public static final String TURBO_SITE_HREF = "turboSiteHref";
    public static final String PRESET = "preset";
    public static final String MODERATION_REQURED = "contentModerationRequired";
    public static final String MODERATION_STATUS = "moderationStatus";

    @JsonProperty(ID)
    private Long id;

    @JsonProperty(NAME)
    private String name;

    @JsonProperty(URL)
    private String url;

    @JsonProperty(COUNTERS)
    private List<IntapiTurboLandingCounter> counters;

    @JsonProperty(VERSION)
    private Long version;

    @JsonProperty(PREVIEW_HREF)
    private String previewHref;

    @Nullable
    @JsonProperty(TURBO_SITE_HREF)
    private String turboSiteHref;

    @Nullable
    @JsonProperty(MODERATION_REQURED)
    private Boolean contentModerationRequired;

    @Nullable
    @JsonProperty(MODERATION_STATUS)
    private TurboPageModerationStatusEnum turboPageModerationStatus;

    @Nullable
    @JsonProperty(PRESET)
    private TurbolandingPreset preset;

    public Long getId() {
        return id;
    }

    public IntapiTurboLanding withId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public IntapiTurboLanding withName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public IntapiTurboLanding withUrl(String url) {
        this.url = url;
        return this;
    }

    public List<IntapiTurboLandingCounter> getCounters() {
        return counters;
    }

    public IntapiTurboLanding withCounters(List<IntapiTurboLandingCounter> counters) {
        this.counters = counters;
        return this;
    }

    public Long getVersion() {
        return version;
    }

    public IntapiTurboLanding withVersion(Long version) {
        this.version = version;
        return this;
    }

    public String getPreviewHref() {
        return previewHref;
    }

    public IntapiTurboLanding withPreviewHref(String previewHref) {
        this.previewHref = previewHref;
        return this;
    }

    @Nullable
    public TurbolandingPreset getPreset() {
        return preset;
    }

    public IntapiTurboLanding withPreset(@Nullable TurbolandingPreset preset) {
        this.preset = preset;
        return this;
    }

    @Nullable
    public Boolean getContentModerationRequired() {
        return contentModerationRequired;
    }

    public IntapiTurboLanding withContentModerationRequired(@Nullable Boolean contentModerationRequired) {
        this.contentModerationRequired = contentModerationRequired;
        return this;
    }

    @Nullable
    public TurboPageModerationStatusEnum getTurboPageModerationStatus() {
        return turboPageModerationStatus;
    }

    public IntapiTurboLanding withTurboPageModerationStatus(
            @Nullable TurboPageModerationStatusEnum turboPageModerationStatus) {
        this.turboPageModerationStatus = turboPageModerationStatus;
        return this;
    }

    @Nullable
    public String getTurboSiteHref() {
        return turboSiteHref;
    }

    public void setTurboSiteHref(@Nullable String turboSiteHref) {
        this.turboSiteHref = turboSiteHref;
    }

    public IntapiTurboLanding withTurboSiteHref(@Nullable String turboSiteHref) {
        setTurboSiteHref(turboSiteHref);
        return this;
    }
}
