package ru.yandex.direct.intapi.entity.turbolandings.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class IntapiTurboLandingCounter {
    public static final String ID = "id";
    public static final String GOALS = "goalsData";
    public static final String OLDSTYLE_GOALS = "goals";
    public static final String IS_USER_COUNTER = "isUserCounter";

    @JsonProperty(ID)
    private Long id;

    @JsonProperty(GOALS)
    private List<IntapiTurboLandingGoal> goals;

    @JsonProperty(OLDSTYLE_GOALS)
    private List<Long> goalsList;

    @JsonProperty(IS_USER_COUNTER)
    private Boolean isUserCounter = false;

    public Long getId() {
        return id;
    }

    public IntapiTurboLandingCounter withId(Long id) {
        this.id = id;
        return this;
    }

    public List<IntapiTurboLandingGoal> getGoals() {
        return goals;
    }

    public IntapiTurboLandingCounter withGoals(List<IntapiTurboLandingGoal> goals) {
        this.goals = goals;
        return this;
    }

    public Boolean getIsUserCounter() {
        return isUserCounter;
    }

    public IntapiTurboLandingCounter withIsUserCounter(Boolean isUserCounter) {
        this.isUserCounter = isUserCounter;
        return this;
    }

    public List<Long> getGoalsList() {
        return goalsList;
    }

    public void setGoalsList(List<Long> goalsList) {
        this.goalsList = goalsList;
    }

    public IntapiTurboLandingCounter withGoalsList(List<Long> goalsList) {
        this.goalsList = goalsList;
        return this;
    }
}
