package ru.yandex.direct.intapi.entity.turbolandings.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

@ApiModel
public class SaveTurbolandingsResult {
    @JsonProperty("turbolandingId")
    private final long turbolandingId;
    private final SaveTurbolandingsResult.Status status;
    private final String message;

    private SaveTurbolandingsResult(long turbolandingId, SaveTurbolandingsResult.Status status, String message) {
        this.status = status;
        this.message = message;
        this.turbolandingId = turbolandingId;
    }

    public static SaveTurbolandingsResult ok(long creativeId) {
        return ok(creativeId, "success");
    }

    public static SaveTurbolandingsResult ok(long creativeId, String message, Object... params) {
        return new SaveTurbolandingsResult(creativeId, SaveTurbolandingsResult.Status.OK, String.format(message,
                params));
    }

    public static SaveTurbolandingsResult error(long turbolandingId, String defects) {
        return new SaveTurbolandingsResult(turbolandingId, SaveTurbolandingsResult.Status.ERROR, defects);
    }

    @ApiModelProperty(
            value = "id турболендинга",
            required = true,
            name = "turbolandingId"
    )
    public long getTurbolandingId() {
        return turbolandingId;
    }

    @ApiModelProperty(
            value = "статус сохранения турбостраницы",
            required = true
    )
    public SaveTurbolandingsResult.Status getStatus() {
        return status;
    }

    @ApiModelProperty(
            value = "статус сохранения турбостраницы: поясняющее сообщение",
            required = true
    )
    public String getMessage() {
        return message;
    }

    public String toString() {
        return new ToStringBuilder(this).
                append("turbolandingId", turbolandingId).
                append("status", status).
                append("message", message).
                toString();
    }

    public enum Status {
        OK,
        ERROR
    }

}
