package ru.yandex.direct.intapi.entity.turbolandings.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.intapi.validation.model.IntapiSuccessResponse;

@ApiModel
public class SaveTurbolandingsSuccessResponse extends IntapiSuccessResponse {

    @JsonProperty
    private final List<SaveTurbolandingsResult> saveTurbolandingsResults;

    public SaveTurbolandingsSuccessResponse(List<SaveTurbolandingsResult> saveTurbolandingsResults) {
        this.saveTurbolandingsResults = saveTurbolandingsResults;
    }

    @Override
    public boolean isSuccessful() {
        return saveTurbolandingsResults
                .stream()
                .allMatch(result -> result.getStatus().equals(SaveTurbolandingsResult.Status.OK));
    }

    @ApiModelProperty(
            value = "результат сохранения турболендингов",
            required = true
    )
    @JsonProperty
    public List<SaveTurbolandingsResult> getSaveTurbolandingsResults() {
        return saveTurbolandingsResults;
    }
}
