package ru.yandex.direct.intapi.entity.turbolandings.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import ru.yandex.direct.intapi.validation.model.IntapiResponse;

@ApiModel
public class TurboLandingInfoResponse implements IntapiResponse {
    @JsonProperty("interface_type")
    private InterfaceTypeEnum interfaceType;

    @JsonProperty("attached_banners_count")
    private Integer bannersCount;

    public InterfaceTypeEnum getInterfaceType() {
        return interfaceType;
    }

    public TurboLandingInfoResponse withInterfaceType(InterfaceTypeEnum interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    public Integer getBannersCount() {
        return bannersCount;
    }

    public TurboLandingInfoResponse withBannersCount(Integer bannersCount) {
        this.bannersCount = bannersCount;
        return this;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }
}
