package ru.yandex.direct.intapi.entity.turbolandings.model;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.dbschema.ppc.enums.TurbolandingsPreset;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;

@ParametersAreNonnullByDefault
public enum TurbolandingPreset {
    EMPTY("empty-preset", TurbolandingsPreset.empty_preset),

    AUTO_LOANS("auto-loans-preset", TurbolandingsPreset.auto_loans_preset),

    COMMODITY("commodity-preset", TurbolandingsPreset.commodity_preset),

    CONTACT_PAGE("contact-page-preset", TurbolandingsPreset.contact_page_preset),

    CPM_GEOPRODUCT("cpm-geoproduct-preset", TurbolandingsPreset.cpm_geoproduct_preset),

    CPM_GEOPRODUCT_PRO("cpm-geoproduct-pro-preset", TurbolandingsPreset.cpm_geoproduct_pro_preset),

    FITNESS_CENTER("fitness-center-preset", TurbolandingsPreset.fitness_center_preset),

    FLOWER_SHOP("flower-shop-preset", TurbolandingsPreset.flower_shop_preset),

    FURNITURE_STORE("furniture-store-preset", TurbolandingsPreset.furniture_store_preset),

    INFORMATIONAL("informational-preset", TurbolandingsPreset.informational_preset),

    LANGUAGE_SCHOOL("language-school-preset", TurbolandingsPreset.language_school_preset),

    MAINTENANCE_COMPANY("maintenance-company-preset", TurbolandingsPreset.maintenance_company_preset),

    PHOTOGRAPHER_PAGE("photographer-page-preset", TurbolandingsPreset.photographer_page_preset),

    PRODUCT_PAGE("product-page-preset", TurbolandingsPreset.product_page_preset),

    SHORT("short-preset", TurbolandingsPreset.short_preset),

    SUBURBAN_COMMUNITY("suburban-community-preset", TurbolandingsPreset.suburban_community_preset);

    private static final Logger logger = LoggerFactory.getLogger(TurbolandingPreset.class);

    private static final Map<String, TurbolandingPreset> PRESETS_BY_NAME = Arrays.stream(TurbolandingPreset.values())
            .collect(toMap(TurbolandingPreset::getName, identity()));

    private final String name;
    private final TurbolandingsPreset coreValue;

    TurbolandingPreset(String name, TurbolandingsPreset coreValue) {
        this.name = name;
        this.coreValue = coreValue;
    }

    public String getName() {
        return name;
    }

    public TurbolandingsPreset getCoreValue() {
        return coreValue;
    }

    @Nullable
    @JsonCreator
    public static TurbolandingPreset parse(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return Optional.ofNullable(PRESETS_BY_NAME.get(s))
                .orElseGet(() -> {
                    logger.warn("Unknown turbolanding preset: {}", s);
                    return EMPTY;
                });
    }
}
