package ru.yandex.direct.intapi.entity.turbolandings.presentation;


import ru.yandex.direct.core.entity.turbolanding.service.validation.defects.TurboLandingDefectIds;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class TurbolandingDefectPresentations {
    private TurbolandingDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> turbolandingDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(TurboLandingDefectIds.MODERATION_REQUIRED_ATTRIBUTE_CANT_BE_CHANGED, defaultIntapiDefect())
                .register(TurboLandingDefectIds.INCONSISTENT_STATE_OF_MODERATION_STATUS, defaultIntapiDefect())
                .build();
    }
}
