package ru.yandex.direct.intapi.entity.turbolandings.service;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.turbolanding.model.StatusModerateForCpa;
import ru.yandex.direct.core.entity.turbolanding.model.StatusPostModerate;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLandingMetrikaCounter;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLandingMetrikaGoal;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLandingWithCountersAndGoals;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.entity.turbolandings.model.IntapiTurboLanding;
import ru.yandex.direct.intapi.entity.turbolandings.model.IntapiTurboLandingCounter;
import ru.yandex.direct.intapi.entity.turbolandings.model.TurboPageModerationStatusEnum;
import ru.yandex.direct.intapi.entity.turbolandings.model.TurbolandingPreset;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.JsonUtils.toJson;

@ParametersAreNonnullByDefault
public class TurboLandingConverter {

    private TurboLandingConverter() {
    }

    public static TurboLandingWithCountersAndGoals toTurboLandingWithCountersAndGoals(
            ClientId clientId,
            IntapiTurboLanding intapiTurboLanding) {
        var turbolandingWithCounterAndGoals = new TurboLandingWithCountersAndGoals();

        turbolandingWithCounterAndGoals
                .withCounters(extractCounters(intapiTurboLanding.getCounters()))
                .withGoals(extractGoals(intapiTurboLanding.getCounters()))
                .withId(intapiTurboLanding.getId())
                .withClientId(clientId.asLong())
                .withName(intapiTurboLanding.getName())
                .withUrl(intapiTurboLanding.getUrl())
                .withVersion(nvl(intapiTurboLanding.getVersion(), 0L))
                .withPreviewHref(nvl(intapiTurboLanding.getPreviewHref(), ""))
                .withTurboSiteHref(intapiTurboLanding.getTurboSiteHref())
                .withPreset(ifNotNull(intapiTurboLanding.getPreset(), TurbolandingPreset::getCoreValue))
                .withStatusPostModerate(StatusPostModerate.YES) // TODO: Статус потом начнет приходить
                .withLastModeratedVersion(0L)
                .withIsCpaModerationRequired(nvl(intapiTurboLanding.getContentModerationRequired(), false))
                .withStatusModerateForCpa(
                        toCoreStatusModerateForCpa(intapiTurboLanding.getTurboPageModerationStatus()))
                .withMetrikaCounters(toJson(intapiTurboLanding.getCounters()));

        return turbolandingWithCounterAndGoals;
    }

    public static StatusModerateForCpa toCoreStatusModerateForCpa(TurboPageModerationStatusEnum external) {
        if (external == null) {
            return null;
        }
        return StatusModerateForCpa.valueOf(external.name());
    }

    public static Set<TurboLandingMetrikaCounter> extractCounters(List<IntapiTurboLandingCounter> counters) {
        return StreamEx.of(counters)
                .nonNull()
                .map(counter -> new TurboLandingMetrikaCounter()
                        .withId(counter.getId())
                        .withIsUserCounter(counter.getIsUserCounter()))
                .toSet();
    }

    public static Set<TurboLandingMetrikaGoal> extractGoals(List<IntapiTurboLandingCounter> counters) {
        return StreamEx.of(counters)
                .nonNull()
                .flatMap(c -> c.getGoals().stream()).nonNull()
                .map(goal -> new TurboLandingMetrikaGoal()
                        .withId(goal.getId())
                        .withIsConversionGoal(goal.getWeight() != null && goal.getWeight() > 0)
                ).toSet();
    }
}
