package ru.yandex.direct.intapi.entity.turbolandings.validation;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.intapi.entity.turbolandings.model.UpdateCounterGrantsIntapiRequestItem;
import ru.yandex.direct.intapi.validation.IntApiDefect;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.constraint.UniqueItemsConstraint;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.intapi.validation.IntApiConstraints.notEmptyCollection;
import static ru.yandex.direct.intapi.validation.IntApiConstraints.notNull;
import static ru.yandex.direct.intapi.validation.IntApiConstraints.validId;


@Service
public class UpdateCounterGrantsValidationService {

    public ValidationResult<List<UpdateCounterGrantsIntapiRequestItem>, IntApiDefect> validate(
            List<UpdateCounterGrantsIntapiRequestItem> params) {
        return ListValidationBuilder.of(params, IntApiDefect.class)
                .check(notNull())
                .check(notEmptyCollection())
                .checkEach(notNull())
                .checkEachBy(this::requestItemIsValid, When.notNull())
                .checkEach(new UniqueItemsConstraint<>(UpdateCounterGrantsIntapiRequestItem::getCounterId,
                        () -> IntApiDefect.notParameterized("duplicate counter_id")), When.isValid())
                .getResult();
    }

    private ValidationResult<UpdateCounterGrantsIntapiRequestItem, IntApiDefect> requestItemIsValid(
            UpdateCounterGrantsIntapiRequestItem param) {
        ItemValidationBuilder<UpdateCounterGrantsIntapiRequestItem, IntApiDefect> v =
                ItemValidationBuilder.of(param, IntApiDefect.class);

        v.item(param.getCounterId(), UpdateCounterGrantsIntapiRequestItem.COUNTER_ID)
                .check(notNull())
                .check(validId());

        v.list(param.getUserIds(), UpdateCounterGrantsIntapiRequestItem.USER_IDS)
                .check(notNull())
                .check(notEmptyCollection())
                .checkEach(notNull())
                .checkEach(validId());

        return v.getResult();
    }
}
