package ru.yandex.direct.intapi.entity.user.controller;

import java.util.List;
import java.util.Map;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.core.MediaType;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.user.model.SendMoneyOutWarningRequestItem;
import ru.yandex.direct.intapi.entity.user.service.IntapiUserService;
import ru.yandex.direct.tvm.AllowServices;
import ru.yandex.direct.web.core.model.WebResponse;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;

@RestController
@RequestMapping(
        name = "users",
        path = "/users",
        produces = org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE)
public class UsersController {
    private static final String USER_INFO_PATH = "info";
    private static final String SEND_MONEY_OUT_WARNING_PATH = "send_money_out_warning";

    private final IntapiUserService intapiUserService;

    @Autowired
    public UsersController(IntapiUserService intapiUserService) {
        this.intapiUserService = intapiUserService;
    }


    @GET
    @ApiOperation(
            value = "получить информацию о пользователях Директа",
            nickname = USER_INFO_PATH,
            httpMethod = "GET"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = USER_INFO_PATH,
            method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON
    )
    @AllowServices(production = {DIRECT_WEB_PROD}, testing = {DIRECT_WEB_TEST, DIRECT_DEVELOPER})
    public WebResponse getUserInfo(
            @RequestParam(name = "user_id") Long userId) {
        return intapiUserService.getInfo(userId);
    }


    @POST
    @ApiOperation(
            value = "отправить указанным пользователям уведомления об окончании средств",
            nickname = SEND_MONEY_OUT_WARNING_PATH,
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = SEND_MONEY_OUT_WARNING_PATH,
            method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON
    )
    @AllowServices(production = {DIRECT_SCRIPTS_PROD}, testing = {DIRECT_SCRIPTS_TEST, DIRECT_DEVELOPER})
    public Map<Long, Boolean> sendMoneyOutWarning(
            @RequestBody List<SendMoneyOutWarningRequestItem> warningItems) {
        return intapiUserService.sendMoneyOutWarnings(warningItems);
    }



}
