package ru.yandex.direct.intapi.entity.user.presentation;

import ru.yandex.direct.core.entity.user.service.validation.UserDefectIds;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class UserDefectPresentations {
    private UserDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> userDefectPresentationRegistry() {
        UserDefectTranslations userDefectTranslations = UserDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(UserDefectIds.Gen.USER_NOT_FOUND,
                        paramIntapiDefect(di -> userDefectTranslations.userNotFound(getValue(di))))

                .register(UserDefectIds.Gen.USER_IS_NOT_REPRESENTATIVE,
                        paramIntapiDefect(di -> userDefectTranslations.userIsNotRepresentative(getValue(di))))

                .register(UserDefectIds.Gen.USER_IS_BLOCKED,
                        paramIntapiDefect(di -> userDefectTranslations.userIsBlocked(getValue(di))))

                .register(UserDefectIds.Gen.USER_ASSOCIATED_WITH_ANOTHER_CLIENT,
                        paramIntapiDefect(di -> userDefectTranslations.userAssociatedWithAnotherClient(getValue(di))))

                .register(UserDefectIds.Gen.BALANCE_USER_ASSOCIATED_WITH_ANOTHER_CLIENT,
                        paramIntapiDefect(di ->
                                userDefectTranslations.balanceUserAssociatedWithAnotherClient(getValue(di))))

                .register(UserDefectIds.Gen.USER_HAS_CARD_PAYMENT_METHOD,
                        paramIntapiDefect(di -> userDefectTranslations.userHasCardPaymentMethod(getValue(di))))

                .register(UserDefectIds.Gen.USER_HAS_ACTIVE_AUTOPAY,
                        paramIntapiDefect(di -> userDefectTranslations.userHasActiveAutopay(getValue(di))))

                .register(UserDefectIds.Gen.CHIEF_DELETION_PROHIBITED,
                        paramIntapiDefect(di -> userDefectTranslations.chiefDeletionProhibited(getValue(di))))

                .register(UserDefectIds.Gen.USER_MUST_BE_MANAGER,
                        paramIntapiDefect(di -> userDefectTranslations.userMustBeManager(getValue(di))))

                .register(UserDefectIds.Gen.USER_MUST_BE_MANAGER_IN_BALANCE,
                        paramIntapiDefect(di -> userDefectTranslations.userMustBeManagerInBalance(getValue(di))))

                .register(UserDefectIds.Gen.USER_HAS_NOT_VALID_NAME,
                        paramIntapiDefect(di -> userDefectTranslations.userHasNotValidName(getValue(di))))

                .register(UserDefectIds.Gen.USER_HAS_NOT_VALID_EMAIL,
                        paramIntapiDefect(di -> userDefectTranslations.userHasNotValidEmail(getValue(di))))

                .register(UserDefectIds.Gen.USER_CANT_BE_UNBLOCKED,
                        paramIntapiDefect(di -> userDefectTranslations.userCantBeUnblocked(getValue(di))))

                .register(UserDefectIds.Gen.USER_HAS_NO_AVAILABLE_CURRENCIES, defaultIntapiDefect())

                .build();
    }

    private static String getValue(DefectInfo<? extends Defect<Void>> di) {
        return di.getValue().toString();
    }

}
