package ru.yandex.direct.intapi.entity.user.presentation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

public interface UserDefectTranslations extends TranslationBundle {

    UserDefectTranslations INSTANCE = I18NBundle.implement(UserDefectTranslations.class);

    @MessageFormatStub("Пользователь с uid={0} не найден")
    Translatable userNotFound(Object value);

    @MessageFormatStub("Пользователь с uid={0} не является представителем клиента")
    Translatable userIsNotRepresentative(Object value);

    @MessageFormatStub("Пользователь с uid={0} заблокирован")
    Translatable userIsBlocked(Object value);

    @MessageFormatStub("Пользователь с uid={0} является представителем другого клиента")
    Translatable userAssociatedWithAnotherClient(Object value);

    @MessageFormatStub("Пользователь с uid={0} в Балансе является представителем другого клиента")
    Translatable balanceUserAssociatedWithAnotherClient(Object value);

    @MessageFormatStub("У пользователя с uid={0} есть привязанные банковские карты")
    Translatable userHasCardPaymentMethod(Object value);

    @MessageFormatStub("У пользователя с uid={0} включены автоплатежи")
    Translatable userHasActiveAutopay(Object value);

    @MessageFormatStub("Пользователь с uid={0} является главным представителем клиента и не может быть удалён")
    Translatable chiefDeletionProhibited(Object value);

    @MessageFormatStub("Пользователь с uid={0} должен иметь роль 'Менеджер' в Директе")
    Translatable userMustBeManager(Object value);

    @MessageFormatStub("Пользователь с uid={0} должен иметь роль 'Менеджер' в Балансе")
    Translatable userMustBeManagerInBalance(Object value);

    @MessageFormatStub("Некоректное имя пользователя у пользователя с uid={0}")
    Translatable userHasNotValidName(Object value);

    @MessageFormatStub("Некоректный email-адрес у пользователя с uid={0}")
    Translatable userHasNotValidEmail(Object value);

    @MessageFormatStub("У пользователя с uid={0} установлен флаг 'cant_unblock' и он не может быть заблокирован")
    Translatable userCantBeUnblocked(Object value);

}
