package ru.yandex.direct.intapi.entity.user.service;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;

public class CampaignNotificationFilter {
    private static final EnumSet<ContentPromotionAdgroupType> API_ONLY_PROMOTIONS =
            EnumSet.of(ContentPromotionAdgroupType.EDA, ContentPromotionAdgroupType.SERVICE);

    private final AdGroupRepository adGroupRepository;
    private final ShardHelper shardHelper;

    public CampaignNotificationFilter(ShardHelper shardHelper, AdGroupRepository adGroupRepository) {
        this.adGroupRepository = adGroupRepository;
        this.shardHelper = shardHelper;
    }

    public Set<Long> shouldSendNotification(Collection<Campaign> campaigns) {
        List<Long> campaignIdsToCheck = campaigns.stream()
                .filter(campaign -> CampaignType.CONTENT_PROMOTION.equals(campaign.getType()))
                .map(Campaign::getId)
                .collect(Collectors.toList());

        Set<Long> nonApiCampaigns = shardHelper.groupByShard(campaignIdsToCheck, ShardKey.CID).stream()
                .map(e -> adGroupRepository.getContentPromotionAdGroupTypeByCampaignId(e.getKey(), e.getValue()))
                .flatMap(map -> map.entrySet().stream())
                .filter(e -> !API_ONLY_PROMOTIONS.contains(e.getValue()))
                .map(Map.Entry::getKey)
                .collect(Collectors.toSet());

        return campaigns.stream()
                .filter(campaign -> !CampaignType.GEO.equals(campaign.getType()) &&
                        (!CampaignType.CONTENT_PROMOTION.equals(campaign.getType()) ||
                                nonApiCampaigns.contains(campaign.getId())))
                .map(Campaign::getId)
                .collect(Collectors.toSet());
    }
}
