package ru.yandex.direct.intapi.entity.user.service;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.intapi.entity.user.model.UserWarningsMailNotificationType;

public class UserWarningsMailTemplateResolver {
    private final Map<Language, Map<UserWarningsMailNotificationType, String>> templateMapping;

    public UserWarningsMailTemplateResolver(
            Map<Language, Map<UserWarningsMailNotificationType, String>> templateMapping) {
        this.templateMapping = templateMapping;
    }

    public String resolveTemplateId(Language lang, UserWarningsMailNotificationType notification) {
        Set<Language> allTemplatesLanguages = getAllLanguagesWithTemplates();
        // Если в шаблонах нет нужного языка - отправляем письмо на русском
        Language userLang = allTemplatesLanguages.contains(lang) ? lang : Language.RU;

        Map<UserWarningsMailNotificationType, String> mappingsForLang = templateMapping.get(userLang);
        return mappingsForLang == null ? null : mappingsForLang.get(notification);
    }

    // возвращает все языки для которых есть шаблоны писем
    private Set<Language> getAllLanguagesWithTemplates() {
        return templateMapping.entrySet().stream()
                .filter(r -> !r.getValue().isEmpty())
                .map(r -> r.getKey())
                .collect(Collectors.toSet());
    }
}
